<?php
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/pdf_helper.php';
require_login();

$id=(int)($_GET['id']??0);
$pdo=db();

$inv=$pdo->prepare("SELECT d.*, c.nombre, c.apellidos, c.direccion, c.postal_code, c.localidad, c.provincia, c.nif_cif
                    FROM documents d JOIN clients c ON c.id=d.client_id
                    WHERE d.id=? AND d.doc_type='invoice'");
$inv->execute([$id]);
$doc=$inv->fetch();
if(!$doc){ exit('Factura no encontrada'); }

$company=$pdo->query("SELECT * FROM company_settings LIMIT 1")->fetch() ?: [];

$pdf=pdf_init('Factura '.$doc['doc_code']);
pdf_header_company($pdf, $company);

// Cliente
$pdf->SetFont('dejavusans','B',10);
$pdf->Cell(0,6,'Cliente',0,1);
$pdf->SetFont('dejavusans','',9);
$pdf->Cell(0,5,trim($doc['nombre'].' '.$doc['apellidos']),0,1);
$pdf->Cell(0,5,$doc['direccion'],0,1);
$pdf->Cell(0,5,trim($doc['postal_code'].' '.$doc['localidad'].' '.$doc['provincia']),0,1);
$pdf->Cell(0,5,'NIF/CIF: '.$doc['nif_cif'],0,1);
$pdf->Ln(3);

// Tabla
$pdf->SetFont('dejavusans','B',9);
$pdf->Cell(110,6,'Concepto',1);
$pdf->Cell(20,6,'Cant.',1,0,'R');
$pdf->Cell(25,6,'Precio',1,0,'R');
$pdf->Cell(25,6,'Importe',1,1,'R');

$pdf->SetFont('dejavusans','',9);
$lines=$pdo->prepare("SELECT * FROM document_lines WHERE document_id=?");
$lines->execute([$id]);
foreach($lines as $l){
  $pdf->Cell(110,6,$l['description'],1);
  $pdf->Cell(20,6,$l['quantity'],1,0,'R');
  $pdf->Cell(25,6,pdf_money($l['unit_price']),1,0,'R');
  $pdf->Cell(25,6,pdf_money($l['total']),1,1,'R');
}

$pdf->Ln(3);
$pdf->Cell(155,6,'Total',0,0,'R');
$pdf->SetFont('dejavusans','B',10);
$pdf->Cell(25,6,pdf_money($doc['total']),1,1,'R');

$pdf->Output('factura_'.$doc['doc_code'].'.pdf','I');
