<?php declare(strict_types=1); ?>
<div class="grid">
  <div class="card">
    <h2>Compartir archivo</h2>
    <p class="small"><b>Archivo:</b> <?= e($file['orig_name']) ?> · <span class="mono"><?= e($file['mime']) ?></span></p>

    <form method="post" action="index.php?route=file_share_save">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="file_id" value="<?= (int)$file['id'] ?>">
      <label>Buscar usuario (username o email)</label>
      <input name="q" placeholder="ej: ana o ana@email.com" required>
      <label>Permiso</label>
      <select name="perm">
        <option value="read">Lectura</option>
        <option value="write">Lectura + escritura (renombrar)</option>
      </select>
      <div class="row" style="margin-top:12px;">
        <button class="btn primary" type="submit">Compartir</button>
        <a class="btn" href="index.php?route=files">Volver</a>
      </div>
      <p class="small">Tras compartir, se asigna al primer usuario que coincida con la búsqueda.</p>
    </form>
  </div>

  <div class="card">
    <h3>Ya compartido con</h3>
    <table class="table">
      <thead><tr><th>Usuario</th><th>Permiso</th><th>Acción</th></tr></thead>
      <tbody>
        <?php if (empty($shares)): ?>
          <tr><td colspan="3" class="small">Nadie todavía</td></tr>
        <?php endif; ?>
        <?php foreach ($shares as $s): ?>
          <tr>
            <td><?= e($s['username']) ?> <span class="small">(<?= e($s['email']) ?>)</span></td>
            <td class="badge"><?= e($s['perm']) ?></td>
            <td>
              <form method="post" action="index.php?route=file_share_revoke" onsubmit="return confirm('¿Revocar?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="file_id" value="<?= (int)$file['id'] ?>">
                <input type="hidden" name="to_user_id" value="<?= (int)$s['to_user_id'] ?>">
                <button class="btn danger" type="submit">Revocar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
