<?php declare(strict_types=1); ?>
<div class="card">
  <div class="row" style="align-items:center;">
    <h2 style="margin:0;">Vista previa</h2>
    <div class="right">
      <a class="btn" href="index.php?route=file_download&id=<?= (int)$file['id'] ?>">Descargar</a>
      <a class="btn" href="index.php?route=files">Volver</a>
    </div>
  </div>

  <p class="small"><b><?= e($file['orig_name']) ?></b> · <?= e($file['mime']) ?> · <?= number_format(((int)$file['size_bytes'])/1024, 1) ?> KB</p>

  <?php if (str_starts_with($file['mime'], 'image/')): ?>
    <img src="index.php?route=file_stream&id=<?= (int)$file['id'] ?>" style="max-width:100%; border-radius: 14px; border:1px solid #e7ebf3;">
  <?php elseif (str_starts_with($file['mime'], 'video/')): ?>
    <video controls style="width:100%; border-radius: 14px; border:1px solid #e7ebf3;">
      <source src="index.php?route=file_stream&id=<?= (int)$file['id'] ?>" type="<?= e($file['mime']) ?>">
    </video>
  <?php elseif (str_starts_with($file['mime'], 'audio/')): ?>
    <audio controls style="width:100%;">
      <source src="index.php?route=file_stream&id=<?= (int)$file['id'] ?>" type="<?= e($file['mime']) ?>">
    </audio>
  <?php else: ?>
    <p class="small">No hay previsualización para este tipo. Puedes descargarlo.</p>
  <?php endif; ?>
</div>
