<?php declare(strict_types=1); ?>
<div class="card">
  <div class="row" style="align-items:center;">
    <h2 style="margin:0;">Admin · Mensajes globales</h2>
    <div class="right"><a class="btn" href="index.php?route=messages">Ir a mensajes</a></div>
  </div>
  <p class="small">Aquí puedes anular/reactivar mensajes globales. Un mensaje anulado no vuelve a mostrarse.</p>

  <table class="table">
    <thead><tr><th>ID</th><th>Estado</th><th>Título</th><th>Fecha</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($broadcasts)): ?>
        <tr><td colspan="5" class="small">No hay broadcasts.</td></tr>
      <?php endif; ?>
      <?php foreach ($broadcasts as $b): ?>
        <tr>
          <td class="mono"><?= (int)$b['id'] ?></td>
          <td>
            <?php $active = ((int)($b['is_active'] ?? 1) === 1); ?>
            <span class="badge"><?= $active ? 'activo' : 'anulado' ?></span>
          </td>
          <td>
            <b><?= e($b['title']) ?></b>
            <div class="small"><?php $snippet = $b['body']; if (strlen($snippet) > 140) $snippet = substr($snippet,0,140).'…'; ?>
            <?= nl2br(e($snippet)) ?></div>
          </td>
          <td class="small"><?= e($b['created_at']) ?></td>
          <td class="row">
            <form method="post" action="index.php?route=admin_broadcast_toggle">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">
              <input type="hidden" name="active" value="<?= $active ? 0 : 1 ?>">
              <button class="btn <?= $active ? '' : 'primary' ?>" type="submit">
                <?= $active ? 'Anular' : 'Reactivar' ?>
              </button>
            </form>
            <form method="post" action="index.php?route=admin_broadcast_delete" onsubmit="return confirm('¿Eliminar definitivamente?');">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">
              <button class="btn danger" type="submit">Eliminar</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
