# IMAStorage (imastorage)

Sistema web en **PHP 8+** con **usuarios**, **roles**, **panel tipo explorador**, subida/gestión de archivos privados, **compartición entre usuarios**, **mensajería privada** y **mensajes globales** (admin → todos con popup).

## Requisitos
- PHP 8.0+ (recomendado 8.1+)
- Extensiones: `pdo_sqlite`, `fileinfo`
- Servidor web Apache o Nginx

> Nota importante: “sin límite de subida” no es realista a nivel de aplicación: el límite lo marca el servidor (`upload_max_filesize`, `post_max_size`, proxy, etc.). Este proyecto **no pone límites adicionales**, pero necesitarás ajustar PHP/servidor si quieres subir ficheros grandes.

## Instalación rápida (Apache / cPanel)
1. Sube **todo** el contenido del ZIP a tu hosting (por ejemplo a `public_html/imastorage/`).
2. Asegúrate de que las carpetas sean escribibles por PHP:
   - `data/`
   - `storage/`
   - `tmp/`
3. Abre en el navegador:
   - `https://TU_DOMINIO/imastorage/public/`
4. Registra el **primer usuario**: se convertirá automáticamente en **ADMIN**.

## Estructura
- `public/` -> Front controller y assets
- `app/` -> Lógica (auth, ficheros, admin, mensajes)
- `storage/` -> Archivos privados por usuario + blobs
- `data/imastorage.sqlite` -> Base de datos SQLite
- `tmp/` -> temporales (si hiciera falta)

## Seguridad (resumen)
- Hash de contraseñas con `password_hash()`
- Control de acceso en cada endpoint
- CSRF tokens en formularios sensibles
- Descargas/streams a través de PHP (no acceso directo a `storage/`)

## Usuario administrador
- El primer usuario registrado se marca como `role=admin`.
- Desde **Admin → Usuarios** puedes:
  - Crear usuarios / Administradores
  - Cambiar roles
  - Revocar permisos de lectura/escritura
  - Eliminar usuarios (borra sus referencias en DB; los ficheros quedan en storage para auditoría, configurable)

## Funciones
- Explorador de archivos: carpetas, mover, renombrar, borrar, descargar, previsualizar.
- Compartir entre usuarios: lectura o lectura+escritura.
- Multimedia: previsualización de imágenes; reproducción de audio/video en navegador.
- Mensajería: usuario↔usuario; admin→todos con popup al entrar.

## Credenciales / Config
Edita `app/config.php` si quieres cambiar rutas.

---
Generado automáticamente.
