<?php declare(strict_types=1); ?>
<div class="grid">
  <div class="card">
    <h2>Compartir carpeta</h2>
    <p class="small"><b>Carpeta:</b> <?= e($folder['name']==='/'?'Raíz':$folder['name']) ?></p>

    <form method="post" action="index.php?route=folder_share_save">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="folder_id" value="<?= (int)$folder['id'] ?>">
      <label>Buscar usuario (username o email)</label>
      <input name="q" placeholder="ej: ana o ana@email.com" required>
      <label>Permiso</label>
      <select name="perm">
        <option value="read">Lectura</option>
        <option value="write">Lectura + escritura</option>
      </select>
      <div class="row" style="margin-top:12px;">
        <button class="btn primary" type="submit">Compartir</button>
        <a class="btn" href="index.php?route=files&folder=<?= (int)$folder['id'] ?>">Volver</a>
      </div>
      <p class="small">Esto da acceso a toda la carpeta y subcarpetas.</p>
    </form>
  </div>

  <div class="card">
    <h3>Ya compartida con</h3>
    <table class="table">
      <thead><tr><th>Usuario</th><th>Permiso</th><th>Acción</th></tr></thead>
      <tbody>
        <?php if (empty($shares)): ?>
          <tr><td colspan="3" class="small">Nadie todavía</td></tr>
        <?php endif; ?>
        <?php foreach ($shares as $s): ?>
          <tr>
            <td><?= e($s['username']) ?> <span class="small">(<?= e($s['email']) ?>)</span></td>
            <td class="badge"><?= e($s['perm']) ?></td>
            <td>
              <form method="post" action="index.php?route=folder_share_revoke" onsubmit="return confirm('¿Revocar?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="folder_id" value="<?= (int)$folder['id'] ?>">
                <input type="hidden" name="to_user_id" value="<?= (int)$s['to_user_id'] ?>">
                <button class="btn danger" type="submit">Revocar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
