<?php
// Normaliza variables (compatibilidad con el controlador)
$breadcrumbs = $breadcrumbs ?? ($crumbs ?? []);
$listing = $listing ?? [];
$folders = $folders ?? ($listing['folders'] ?? []);
$files   = $files   ?? ($listing['files'] ?? []);
$allFolders = $allFolders ?? ($allFolders ?? []);
$folder = $folder ?? ['id'=>0,'name'=>'','parent_id'=>0];
?>
<?php if (isset($_SESSION['flash_ok'])): ?>
  <div class="alert ok"><?= e($_SESSION['flash_ok']); unset($_SESSION['flash_ok']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['flash_err'])): ?>
  <div class="alert err"><?= e($_SESSION['flash_err']); unset($_SESSION['flash_err']); ?></div>
<?php endif; ?>

<div class="two-pane">
  <aside class="sidebar card">
    <div class="sidebar-head">
      <div class="brand-mini">Carpetas</div>
      <div class="crumbs">
        <?php foreach ($breadcrumbs as $i => $bc): ?>
          <?php if ($i > 0): ?><span class="sep">/</span><?php endif; ?>
          <a href="index.php?route=files&folder=<?= (int)$bc['id'] ?>"><?= e($bc['name']) ?></a>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="sidebar-actions">
      <form method="post" action="index.php?route=folder_create" class="row" style="gap:8px;">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="parent_id" value="<?= (int)$folder['id'] ?>">
        <input name="name" placeholder="Nueva carpeta" required>
        <button class="btn primary" type="submit">Crear</button>
      </form>
    </div>

    <div class="folder-list">
      <?php if ($folder['id'] != 0): ?>
        <a class="folder-item up" href="index.php?route=files&folder=<?= (int)$folder['parent_id'] ?>">
          <span class="ico">↩</span><span>Subir</span>
        </a>
      <?php endif; ?>

      <?php foreach ($folders as $d): ?>
        <a class="folder-item" href="index.php?route=files&folder=<?= (int)$d['id'] ?>">
          <span class="ico">📁</span>
          <span class="name"><?= e($d['name']) ?></span>
          <span class="meta"><?= e(substr($d['created_at'],0,10)) ?></span>
        </a>
      <?php endforeach; ?>

      <?php if (count($folders) === 0): ?>
        <div class="muted small">No hay subcarpetas aquí.</div>
      <?php endif; ?>
    </div>
  </aside>

  <main class="content">
    <div class="card">
      <div class="content-head">
        <div>
          <h2 style="margin:0;">Mis archivos</h2>
          <div class="small muted">Carpeta actual: <b><?= e($folder['name'] ?: 'Raíz') ?></b></div>
        </div>

        <form method="post" action="index.php?route=file_upload" enctype="multipart/form-data" class="row" style="gap:8px; flex-wrap:wrap;">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="folder_id" value="<?= (int)$folder['id'] ?>">
          <input type="file" name="file" required>
          <button class="btn primary" type="submit">Subir</button>
        </form>
      </div>

      <div id="dropZone" class="dropzone">
        Arrastra y suelta archivos aquí para subirlos.
        <div class="small muted" id="uploadStatus"></div>
      </div>

      <?php if (count($files) === 0): ?>
        <div class="muted">No hay archivos en esta carpeta.</div>
      <?php else: ?>
        <div class="file-grid">
          <?php foreach ($files as $fi): ?>
            <div class="file-card">
              <div class="file-top">
                <div class="file-ico">📄</div>
                <div class="file-name" title="<?= e($fi['orig_name']) ?>"><?= e($fi['orig_name']) ?></div>
                <div class="file-meta small"><?= e(human_bytes((int)$fi['size_bytes'])) ?> · <?= e($fi['mime']) ?></div>
              </div>

              <div class="file-actions">
                <a class="btn" href="index.php?route=file_view&id=<?= (int)$fi['id'] ?>">Ver</a>
                <a class="btn" href="index.php?route=file_download&id=<?= (int)$fi['id'] ?>">Descargar</a>
              </div>

              <div class="file-actions">
                <form method="post" action="index.php?route=file_rename" class="row" style="gap:6px; width:100%;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                  <input name="name" value="<?= e($fi['orig_name']) ?>" style="flex:1;">
                  <button class="btn" type="submit">OK</button>
                </form>
              </div>

              <div class="file-actions">
                <form method="post" action="index.php?route=file_move" class="row" style="gap:6px; width:100%;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                  <select name="dest_folder" style="flex:1;">
                    <?php foreach ($allFolders as $af): ?>
                      <option value="<?= (int)$af['id'] ?>"><?= e($af['path']) ?></option>
                    <?php endforeach; ?>
                  </select>
                  <button class="btn" type="submit">Mover</button>
                </form>
              </div>

              <div class="file-actions">
                <form method="post" action="index.php?route=file_delete" onsubmit="return confirm('¿Borrar este archivo?');" style="width:100%;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                  <button class="btn danger" type="submit" style="width:100%;">Borrar</button>
                </form>
              </div>

              <div class="file-actions">
                <a class="btn" href="index.php?route=share_file&id=<?= (int)$fi['id'] ?>">Compartir</a>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>

    </div>
  </main>
</div>

<script src="assets/dragdrop.js" defer></script>
