<?php
$title='Cliente';
require_once __DIR__ . '/../inc/header.php';
$pdo=db();
$id=(int)($_GET['id']??0);

$st=$pdo->prepare("SELECT * FROM clients WHERE id=?");
$st->execute([$id]);
$client=$st->fetch();
if(!$client){ http_response_code(404); exit('Cliente no encontrado'); }
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0"><?= h(trim(($client['nombre']??'').' '.($client['apellidos']??''))) ?></h4>
    <div class="text-muted">Nº cliente: <?= h($client['customer_no'] ?? '') ?></div>
  </div>
  <div class="d-flex gap-2 flex-wrap">
    <a class="btn btn-outline-secondary" href="<?= url('clientes/edit.php?id='.$id) ?>">Editar</a>
    <a class="btn btn-outline-primary" href="<?= url('presupuestos/new.php?client_id='.$id) ?>">Crear presupuesto</a>
    <a class="btn btn-primary" href="<?= url('facturas/new.php?client_id='.$id) ?>">Crear factura</a>
    <a class="btn btn-outline-secondary" href="<?= url('clientes/list.php') ?>">Volver</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-lg-6">
    <div class="card shadow-sm"><div class="card-body">
      <div class="row g-2">
        <div class="col-md-6"><div class="text-muted small">Nombre</div><div class="fw-semibold"><?= h($client['nombre'] ?? '') ?></div></div>
        <div class="col-md-6"><div class="text-muted small">Apellidos</div><div class="fw-semibold"><?= h($client['apellidos'] ?? '') ?></div></div>

        <div class="col-12"><div class="text-muted small">Dirección</div><div class="fw-semibold"><?= h($client['direccion'] ?? '') ?></div></div>
        <div class="col-md-4"><div class="text-muted small">CP</div><div class="fw-semibold"><?= h($client['postal_code'] ?? '') ?></div></div>
        <div class="col-md-4"><div class="text-muted small">Localidad</div><div class="fw-semibold"><?= h($client['localidad'] ?? '') ?></div></div>
        <div class="col-md-4"><div class="text-muted small">Provincia</div><div class="fw-semibold"><?= h($client['provincia'] ?? '') ?></div></div>

        <div class="col-md-6"><div class="text-muted small">NIF/CIF</div><div class="fw-semibold"><?= h($client['nif_cif'] ?? '') ?></div></div>
        <div class="col-md-6"><div class="text-muted small">Teléfono</div><div class="fw-semibold"><?= h($client['telefono'] ?? '') ?></div></div>
      </div>
    </div></div>

    <?php require __DIR__ . '/../inc/client_map_widget.php'; ?>
  </div>

  <div class="col-lg-6">
    <div class="card shadow-sm"><div class="card-body">
      <h6 class="mb-2">Archivos</h6>
      <div class="text-muted small">Tus adjuntos siguen en la ficha (si ya los tenías). (No se toca en este parche)</div>
    </div></div>
  </div>
</div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
