<?php
$title='Mi panel';
require_once __DIR__ . '/../inc/header.php';
if(!is_client_user()){ redirect('dashboard.php'); }

$pdo=db();
$user=current_user();
$client_id = (int)($user['client_id'] ?? 0);
if(!$client_id){
  flash_set('danger','Tu usuario no está asociado a ningún cliente.');
  redirect('logout.php');
}

$client = $pdo->prepare("SELECT * FROM clients WHERE id=?");
$client->execute([$client_id]);
$c = $client->fetch();
if(!$c){ flash_set('danger','Cliente no encontrado.'); redirect('logout.php'); }

$docs=$pdo->prepare("
  SELECT d.*,
         IFNULL(p.paid_total,0) AS paid_total,
         ROUND(GREATEST(d.total - IFNULL(p.paid_total,0), 0), 2) AS pending_total
  FROM documents d
  LEFT JOIN (
     SELECT invoice_id, SUM(amount) AS paid_total
     FROM invoice_payments
     GROUP BY invoice_id
  ) p ON p.invoice_id=d.id
  WHERE d.client_id=?
  ORDER BY d.issue_date DESC, d.id DESC
");
$docs->execute([$client_id]);
$docRows=$docs->fetchAll();

$msgs=$pdo->prepare("SELECT * FROM messages WHERE client_id=? ORDER BY created_at DESC LIMIT 10");
$msgs->execute([$client_id]);
$messages=$msgs->fetchAll();

$pdo->prepare("UPDATE messages SET is_read=1 WHERE client_id=? AND is_read=0")->execute([$client_id]);
?>
<div class="card shadow-sm"><div class="card-body">
  <h4 class="mb-1">Hola, <?= h(trim(($c['nombre']??'')." ".($c['apellidos']??''))) ?></h4>
  <div class="text-muted">Aquí puedes ver tus presupuestos, facturas y mensajes.</div>
</div></div>

<div class="row g-3 mt-0">
  <div class="col-lg-7">
    <div class="card shadow-sm"><div class="card-body">
      <h6 class="mb-2">Tus documentos</h6>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Tipo</th><th>Código</th><th>Fecha</th><th class="text-end">Total</th><th class="text-end">Pendiente</th><th class="text-end"></th></tr></thead>
          <tbody>
            <?php foreach($docRows as $d): ?>
              <tr>
                <td><?= $d['doc_type']==='invoice'?'Factura':'Presupuesto' ?></td>
                <td class="fw-semibold"><?= h($d['doc_code']) ?></td>
                <td><?= h($d['issue_date']) ?></td>
                <td class="text-end"><?= eur($d['total']) ?></td>
                <td class="text-end">
                  <?php if($d['doc_type']!=='invoice'): ?><span class="text-muted">—</span>
                  <?php else: $pend=(float)$d['pending_total']; ?>
                    <span class="badge <?= $pend>0?'text-bg-warning':'text-bg-success' ?>"><?= eur($pend) ?></span>
                  <?php endif; ?>
                </td>
                <td class="text-end">
                  <?php if($d['doc_type']==='invoice'): ?>
                    <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?= url('facturas/pdf.php?id='.(int)$d['id']) ?>">PDF</a>
                  <?php else: ?>
                    <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?= url('presupuestos/pdf.php?id='.(int)$d['id']) ?>">PDF</a>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$docRows): ?><tr><td colspan="6" class="text-muted">Aún no hay documentos.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div></div>
  </div>

  <div class="col-lg-5">
    <div class="card shadow-sm"><div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <h6 class="mb-0">Mensajes</h6>
        <a class="btn btn-sm btn-outline-primary" href="<?= url('messages/inbox.php') ?>">Ver</a>
      </div>
      <?php if(!$messages): ?>
        <div class="text-muted">No tienes mensajes.</div>
      <?php else: ?>
        <div class="list-group list-group-flush">
          <?php foreach($messages as $m): ?>
            <div class="list-group-item">
              <div class="small text-muted"><?= h($m['created_at']) ?></div>
              <div class="fw-semibold"><?= h($m['subject']) ?></div>
              <div><?= nl2br(h($m['body'])) ?></div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div></div>
  </div>
</div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
