<?php
$title='Usuarios';
require_once __DIR__ . '/../inc/header.php';
if(!is_admin()){ http_response_code(403); exit('Solo admin'); }

$pdo=db();

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $username=trim((string)($_POST['username']??''));
  $password=(string)($_POST['password']??'');
  $role=trim((string)($_POST['role']??'staff'));
  $client_id = (int)($_POST['client_id']??0);

  if($username==='' || $password===''){
    flash_set('danger','Usuario y contraseña son obligatorios.');
    redirect('admin/users.php');
  }
  if(!in_array($role, ['admin','staff','client'], true)) $role='staff';
  if($role!=='client') $client_id = 0;
  if($role==='client' && $client_id<=0){
    flash_set('danger','Para usuario cliente, selecciona un cliente.');
    redirect('admin/users.php');
  }

  $hash=password_hash($password, PASSWORD_DEFAULT);
  $st=$pdo->prepare("INSERT INTO users(username,password_hash,role,client_id,is_admin) VALUES(?,?,?,?,?)");
  $st->execute([$username,$hash,$role,$client_id,$role==='admin'?1:0]);
  flash_set('success','Usuario creado.');
  redirect('admin/users.php');
}

$users = $pdo->query("SELECT id,username,role,client_id FROM users ORDER BY id DESC LIMIT 200")->fetchAll();
$clients = $pdo->query("SELECT id,nombre,apellidos FROM clients ORDER BY nombre ASC LIMIT 500")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Usuarios</h4>
</div>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card shadow-sm"><div class="card-body">
      <h6>Crear usuario</h6>
      <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <div class="col-12"><label class="form-label">Usuario</label><input class="form-control" name="username" required></div>
        <div class="col-12"><label class="form-label">Contraseña</label><input class="form-control" name="password" type="password" required></div>
        <div class="col-md-6">
          <label class="form-label">Rol</label>
          <select class="form-select" name="role" id="role">
            <option value="staff">Empleado</option>
            <option value="admin">Admin</option>
            <option value="client">Cliente</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Cliente asociado</label>
          <select class="form-select" name="client_id" id="client_id">
            <option value="0">—</option>
            <?php foreach($clients as $c): ?>
              <option value="<?= (int)$c['id'] ?>"><?= h(trim($c['nombre'].' '.$c['apellidos'])) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-12"><button class="btn btn-primary">Crear</button></div>
      </form>
      <div class="text-muted small mt-2">Empleados = staff. Clientes = acceso solo a su panel.</div>
    </div></div>
  </div>

  <div class="col-lg-7">
    <div class="card shadow-sm"><div class="card-body">
      <h6>Listado</h6>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>ID</th><th>Usuario</th><th>Rol</th><th>Cliente</th></tr></thead>
          <tbody>
            <?php foreach($users as $u): ?>
              <tr>
                <td><?= (int)$u['id'] ?></td>
                <td class="fw-semibold"><?= h($u['username']) ?></td>
                <td><?= h($u['role']) ?></td>
                <td><?= $u['client_id'] ? (int)$u['client_id'] : '—' ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$users): ?><tr><td colspan="4" class="text-muted">Sin usuarios.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div></div>
  </div>
</div>

<script>
(function(){
  const role=document.getElementById('role');
  const client=document.getElementById('client_id');
  function sync(){ client.disabled = role.value !== 'client'; }
  role.addEventListener('change', sync); sync();
})();
</script>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
